function modifikovanaiteracija(e)

% prvo resenje se nalazi u intervalu [-0.53,-0.52], i f(-0.53)*f(-0.52)<0
% m i M su min i max po modulu od f'(x)

a=-0.53;
b=-0.52;
m=2.6219;
M=2.6456;
q=(M-m)/(M+m);
lambda=2/(M+m);
briteracija1=[];   % niz u kojem pamtimo broj iteracija
for j=1:length(e)
    x0=(a+b)/2;
    x1=x0-lambda*(4*exp(x0)-5*(x0+1));
    i=0;
    while (abs(x0-x1) > ((1-q)/q)*e(j))   % kriterijum zaustavljanja
      x0=x1;
      x1=x0-lambda*(4*exp(x0)-5*(x0+1));
      i=i+1;
  end
  briteracija1=[briteracija1,i]; 
end
prvo_resenje_je=x1

% drugo resenje se nalazi u intervalu [0.5,1.0] i f(0.5)*f(1)<0

a1=0.5;
b1=1;
m=1.5949;
M=5.8731;
q=(M-m)/(M+m);
lambda=2/(M+m);
briteracija2=[];   % niz u kojem pamtimo broj iteracija
for j=1:length(e)
    x0=(a1+b1)/2;
    x1=x0-lambda*(4*exp(x0)-5*(x0+1));
    i=0;
    while (abs(x0-x1) > ((1-q)/q)*e(j))
      x0=x1;
      x1=x0-lambda*(4*exp(x0)-5*(x0+1));
      i=i+1;
  end
  briteracija2=[briteracija2,i];
end
drugo_resenje_je=x1

hold off
hold on
plot(e,briteracija1);
plot(e,briteracija2,'m');